/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem.core;

import com.affehund.voidtotem.VoidTotem;
import com.affehund.voidtotem.api.VoidTotemEvent;
import com.affehund.voidtotem.core.VoidTotemConfig;
import com.affehund.voidtotem.core.VoidTotemTags;
import com.affehund.voidtotem.core.network.PacketHandler;
import com.affehund.voidtotem.core.network.TotemEffectPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class ModUtils {
    public static boolean isModLoaded(String modID) {
        return ModList.get() != null && ModList.get().getModContainerById(modID).isPresent();
    }

    public static boolean tryUseVoidTotem(LivingEntity livingEntity, DamageSource source) {
        if (!ModUtils.isDimensionBlacklisted(livingEntity) && ModUtils.isOutOfWorld(source, livingEntity)) {
            if (ModUtils.isAwaitingPositionFromClient(livingEntity)) {
                return false;
            }
            ItemStack stack = ModUtils.getTotemItemStack(livingEntity);
            if (stack != null) {
                VoidTotemEvent event = new VoidTotemEvent(stack, livingEntity, source);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.getResult().equals((Object)Event.Result.ALLOW)) {
                    return true;
                }
                if (event.getResult().equals((Object)Event.Result.DENY)) {
                    return false;
                }
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    player.f_8906_.f_9737_ = 0;
                    ModUtils.giveUseStatAndCriterion(stack, player);
                }
                stack = ModUtils.damageOrShrinkItemStack(stack, livingEntity);
                if (livingEntity.m_20160_()) {
                    livingEntity.m_20153_();
                }
                livingEntity.m_8127_();
                livingEntity.m_21153_(1.0f);
                livingEntity.getPersistentData().m_128379_("Void TotemIsFallDamageImmune", true);
                ModUtils.teleportToSavePosition(livingEntity);
                ModUtils.sendTotemEffectPacket(stack, livingEntity);
                return true;
            }
        }
        return false;
    }

    public static boolean isDimensionBlacklisted(LivingEntity livingEntity) {
        return ((ArrayList)VoidTotemConfig.COMMON_CONFIG.BLACKLISTED_DIMENSIONS.get()).contains(livingEntity.f_19853_.m_46472_().m_135782_().toString());
    }

    public static boolean isOutOfWorld(DamageSource source, LivingEntity livingEntity) {
        return source.equals(DamageSource.f_19317_) && livingEntity.m_20186_() < (double)livingEntity.f_19853_.m_141937_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAwaitingPositionFromClient(LivingEntity livingEntity) {
        if (!(livingEntity instanceof ServerPlayer)) return false;
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (player.f_8906_.f_9766_ == null) return false;
        return true;
    }

    public static ItemStack getTotemItemStack(LivingEntity player) {
        if (((Boolean)VoidTotemConfig.COMMON_CONFIG.NEEDS_TOTEM.get()).booleanValue()) {
            List<ItemStack> possibleTotemStacks = ModUtils.filterPossibleTotemStacks(ModUtils.getTotemFromCurios(player), ModUtils.getTotemFromInventory(player), ModUtils.getTotemFromHands(player));
            return possibleTotemStacks.stream().findFirst().orElse(null);
        }
        return ItemStack.f_41583_;
    }

    public static List<ItemStack> filterPossibleTotemStacks(ItemStack ... stacks) {
        return Arrays.stream(stacks).filter(Objects::nonNull).toList();
    }

    public static ItemStack getTotemFromCurios(LivingEntity livingEntity) {
        if (ModUtils.isModLoaded("curios")) {
            return ModUtils.findCuriosItem(livingEntity, ModUtils::isVoidTotemOrAdditionalTotem);
        }
        return null;
    }

    public static ItemStack findCuriosItem(LivingEntity livingEntity, Predicate<ItemStack> filter) {
        return CuriosApi.getCuriosHelper().findFirstCurio(livingEntity, filter).map(SlotResult::stack).orElse(null);
    }

    public static ItemStack getTotemFromInventory(LivingEntity livingEntity) {
        if (((Boolean)VoidTotemConfig.COMMON_CONFIG.USE_TOTEM_FROM_INVENTORY.get()).booleanValue() && livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!ModUtils.isVoidTotemOrAdditionalTotem(stack)) continue;
                return stack;
            }
        }
        return null;
    }

    public static ItemStack getTotemFromHands(LivingEntity player) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.m_21120_(hand);
            if (!ModUtils.isVoidTotemOrAdditionalTotem(stack)) continue;
            return stack;
        }
        return null;
    }

    public static boolean isVoidTotemOrAdditionalTotem(ItemStack stack) {
        return ModUtils.isVoidTotem(stack) || ModUtils.isAdditionalTotem(stack);
    }

    public static boolean isVoidTotem(ItemStack stack) {
        return stack.m_41720_().equals(VoidTotem.VOID_TOTEM_ITEM.get());
    }

    public static boolean isAdditionalTotem(ItemStack stack) {
        return stack.m_204117_(VoidTotemTags.ADDITIONAL_TOTEMS);
    }

    public static ItemStack damageOrShrinkItemStack(ItemStack stack, LivingEntity livingEntity) {
        ItemStack copiedStack = stack.m_41777_();
        if (stack.m_41763_()) {
            stack.m_41622_(1, livingEntity, e -> e.m_21190_(livingEntity.m_7655_()));
        } else {
            stack.m_41774_(1);
        }
        return copiedStack;
    }

    public static void giveUseStatAndCriterion(ItemStack stack, ServerPlayer player) {
        if (!stack.m_41619_()) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            CriteriaTriggers.f_10551_.m_74431_(player, stack);
        }
    }

    public static void teleportToSavePosition(LivingEntity livingEntity) {
        BlockPos lastPos = BlockPos.m_122022_((long)livingEntity.getPersistentData().m_128454_("Void TotemLastSaveBlockPos"));
        BlockPos positionInRadius = ModUtils.positionNearby(livingEntity, lastPos);
        if (positionInRadius == null) {
            livingEntity.m_6021_((double)lastPos.m_123341_(), (double)(livingEntity.f_19853_.m_151558_() + (Integer)VoidTotemConfig.COMMON_CONFIG.TELEPORT_HEIGHT_OFFSET.get()), (double)lastPos.m_123343_());
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                player.f_8906_.f_9737_ = 0;
            }
        }
    }

    public static BlockPos positionNearby(LivingEntity livingEntity, BlockPos lastPos) {
        BlockPos teleportPos = null;
        for (int i = 0; i < 16; ++i) {
            Level level = livingEntity.f_19853_;
            double x = (double)lastPos.m_123341_() + (livingEntity.m_21187_().nextDouble() - 0.5) * 16.0;
            double y = Mth.m_14008_((double)((double)lastPos.m_123342_() + (double)(livingEntity.m_21187_().nextInt(16) - 8)), (double)level.m_141937_(), (double)(level.m_151558_() - 1));
            double z = (double)lastPos.m_123343_() + (livingEntity.m_21187_().nextDouble() - 0.5) * 16.0;
            BlockPos pos = new BlockPos(x, y, z);
            if (!livingEntity.m_20984_(x, y, z, true)) continue;
            teleportPos = pos;
            break;
        }
        return teleportPos;
    }

    public static void sendTotemEffectPacket(ItemStack stack, LivingEntity livingEntity) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            PacketHandler.sendToPlayer(new TotemEffectPacket(stack, (Entity)player), player);
        }
        PacketHandler.sendToAllTracking(new TotemEffectPacket(stack, (Entity)livingEntity), livingEntity);
    }

    public static void setLastSaveBlockPos(LivingEntity livingEntity) {
        Level level = livingEntity.f_19853_;
        BlockPos currentPos = livingEntity.m_142538_();
        BlockPos lastPos = BlockPos.m_122022_((long)livingEntity.getPersistentData().m_128454_("Void TotemLastSaveBlockPos"));
        if (!(!ModUtils.isSaveBlockPos(level, currentPos.m_7495_()) || lastPos.equals((Object)currentPos) && ModUtils.isSaveBlockPos(level, lastPos.m_7495_()))) {
            livingEntity.getPersistentData().m_128356_("Void TotemLastSaveBlockPos", currentPos.m_121878_());
        }
    }

    public static boolean isSaveBlockPos(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60796_((BlockGetter)level, pos);
    }

    public static void resetFallDamageImmunity(LivingEntity livingEntity) {
        if (livingEntity.getPersistentData().m_128471_("Void TotemIsFallDamageImmune")) {
            boolean canPlayerFly = false;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                player.f_8906_.f_9737_ = 0;
                Abilities abilities = player.m_150110_();
                if (abilities.f_35935_ || abilities.f_35936_) {
                    canPlayerFly = true;
                }
            }
            if (livingEntity.m_20069_() || livingEntity.f_19853_.m_8055_(livingEntity.m_142538_()).m_60734_() == Blocks.f_50033_ || canPlayerFly) {
                livingEntity.getPersistentData().m_128379_("Void TotemIsFallDamageImmune", false);
            }
        }
    }
}

